<!DOCTYPE html>
<html lang="en">
<head>
    <meta charset="UTF-8">
    <meta name="viewport" content="width=device-width, initial-scale=1.0">
    <title>Admin Login - <?php echo htmlspecialchars($app->config('app.name')); ?></title>
    <meta name="description" content="Secure admin access to <?php echo htmlspecialchars($app->config('app.name')); ?>">
    <meta name="robots" content="noindex, nofollow">
    
    <!-- Preload critical resources -->
    <link rel="preload" href="assets/css/admin.css" as="style">
    <link rel="preload" href="assets/js/admin.js" as="script">
    
    <!-- Stylesheets -->
    <link rel="stylesheet" href="assets/css/admin.css">
    
    <!-- Security headers -->
    <meta http-equiv="X-Content-Type-Options" content="nosniff">
    <meta http-equiv="X-Frame-Options" content="DENY">
    <meta http-equiv="X-XSS-Protection" content="1; mode=block">
    
    <style>
        /* Login-specific styles */
        body {
            margin: 0;
            padding: 0;
            font-family: -apple-system, BlinkMacSystemFont, 'Segoe UI', Roboto, sans-serif;
            background: linear-gradient(135deg, #667eea 0%, #764ba2 100%);
            min-height: 100vh;
            display: flex;
            align-items: center;
            justify-content: center;
        }

        .login-container {
            background: rgba(255, 255, 255, 0.95);
            backdrop-filter: blur(10px);
            border-radius: 20px;
            padding: 40px;
            box-shadow: 0 20px 40px rgba(0, 0, 0, 0.1);
            width: 100%;
            max-width: 450px;
            margin: 20px;
        }

        .logo {
            text-align: center;
            margin-bottom: 30px;
        }

        .logo h1 {
            color: #333;
            font-size: 2rem;
            margin: 0 0 10px 0;
            font-weight: 700;
        }

        .logo p {
            color: #666;
            margin: 0;
            font-size: 1rem;
        }

        .version {
            background: #f8f9fa;
            color: #6c757d;
            padding: 4px 8px;
            border-radius: 12px;
            font-size: 0.75rem;
            margin-top: 10px;
            display: inline-block;
        }

        .form-group {
            margin-bottom: 20px;
        }

        .form-label {
            display: block;
            font-weight: 600;
            color: #333;
            margin-bottom: 8px;
            font-size: 0.95rem;
        }

        .password-input {
            position: relative;
        }

        .form-control {
            width: 100%;
            padding: 15px 20px;
            border: 2px solid #e9ecef;
            border-radius: 12px;
            font-size: 1rem;
            transition: all 0.3s ease;
            background: white;
            box-sizing: border-box;
        }

        .form-control:focus {
            outline: none;
            border-color: #667eea;
            box-shadow: 0 0 0 3px rgba(102, 126, 234, 0.1);
        }

        .password-toggle {
            position: absolute;
            right: 15px;
            top: 50%;
            transform: translateY(-50%);
            background: none;
            border: none;
            color: #666;
            cursor: pointer;
            font-size: 1.2rem;
            padding: 5px;
            border-radius: 4px;
            transition: color 0.2s ease;
        }

        .password-toggle:hover {
            color: #667eea;
        }

        .login-btn {
            width: 100%;
            padding: 15px;
            background: linear-gradient(135deg, #667eea, #764ba2);
            color: white;
            border: none;
            border-radius: 12px;
            font-size: 1.1rem;
            font-weight: 600;
            cursor: pointer;
            transition: all 0.3s ease;
            margin-top: 10px;
            position: relative;
            overflow: hidden;
        }

        .login-btn:hover:not(:disabled) {
            transform: translateY(-2px);
            box-shadow: 0 10px 30px rgba(102, 126, 234, 0.3);
        }

        .login-btn:disabled {
            opacity: 0.7;
            cursor: not-allowed;
            transform: none;
        }

        .loading {
            display: none;
            align-items: center;
            gap: 10px;
            justify-content: center;
            margin-top: 15px;
        }

        .spinner {
            width: 20px;
            height: 20px;
            border: 2px solid #f3f3f3;
            border-top: 2px solid #667eea;
            border-radius: 50%;
            animation: spin 1s linear infinite;
        }

        @keyframes spin {
            0% { transform: rotate(0deg); }
            100% { transform: rotate(360deg); }
        }

        .alert {
            padding: 15px;
            border-radius: 10px;
            margin-bottom: 20px;
            font-weight: 500;
        }

        .alert-error {
            background: #f8d7da;
            color: #721c24;
            border-left: 4px solid #dc3545;
        }

        .alert-success {
            background: #d4edda;
            color: #155724;
            border-left: 4px solid #28a745;
        }

        .alert-warning {
            background: #fff3cd;
            color: #856404;
            border-left: 4px solid #ffc107;
        }

        .remember-me {
            display: flex;
            align-items: center;
            gap: 8px;
            margin: 15px 0;
        }

        .remember-me input[type="checkbox"] {
            width: 18px;
            height: 18px;
            accent-color: #667eea;
        }

        .remember-me label {
            font-size: 0.9rem;
            color: #666;
            cursor: pointer;
        }

        .features {
            margin-top: 30px;
            text-align: left;
        }

        .features h3 {
            color: #333;
            font-size: 1.1rem;
            margin-bottom: 15px;
            text-align: center;
        }

        .feature-list {
            list-style: none;
            padding: 0;
            margin: 0;
        }

        .feature-list li {
            padding: 8px 0;
            color: #666;
            font-size: 0.9rem;
            display: flex;
            align-items: center;
            gap: 10px;
        }

        .feature-list li::before {
            content: '✓';
            color: #28a745;
            font-weight: bold;
            font-size: 1rem;
            flex-shrink: 0;
        }

        .security-info {
            margin-top: 25px;
            padding: 15px;
            background: #f8f9fa;
            border-radius: 10px;
            text-align: center;
        }

        .security-info p {
            margin: 5px 0;
            font-size: 0.85rem;
            color: #6c757d;
        }

        .help-text {
            margin-top: 20px;
            text-align: center;
        }

        .help-text p {
            color: #666;
            font-size: 0.9rem;
            margin: 5px 0;
        }

        .help-text a {
            color: #667eea;
            text-decoration: none;
            font-weight: 500;
        }

        .help-text a:hover {
            text-decoration: underline;
        }

        .footer {
            margin-top: 30px;
            padding-top: 20px;
            border-top: 1px solid #eee;
            text-align: center;
            color: #999;
            font-size: 0.85rem;
        }

        /* Responsive design */
        @media (max-width: 480px) {
            .login-container {
                padding: 30px 20px;
                margin: 10px;
                border-radius: 15px;
            }

            .logo h1 {
                font-size: 1.75rem;
            }

            .form-control {
                padding: 12px 15px;
            }

            .login-btn {
                padding: 12px;
            }
        }

        /* Dark mode support */
        @media (prefers-color-scheme: dark) {
            .login-container {
                background: rgba(40, 44, 52, 0.95);
                color: #e6e6e6;
            }

            .logo h1,
            .form-label {
                color: #e6e6e6;
            }

            .logo p,
            .feature-list li {
                color: #b0b0b0;
            }

            .form-control {
                background: rgba(255, 255, 255, 0.1);
                border-color: rgba(255, 255, 255, 0.2);
                color: #e6e6e6;
            }

            .form-control:focus {
                border-color: #667eea;
                background: rgba(255, 255, 255, 0.15);
            }

            .security-info {
                background: rgba(255, 255, 255, 0.1);
            }
        }
    </style>
</head>
<body>
    <div class="login-container">
        <!-- Logo and Title -->
        <div class="logo">
            <h1>🔐 Admin Login</h1>
            <p><?php echo htmlspecialchars($app->config('app.name')); ?></p>
            <span class="version">v<?php echo htmlspecialchars($app->config('app.version')); ?></span>
        </div>

        <!-- Alert Messages -->
        <?php if (!empty($loginError)): ?>
            <div class="alert alert-error" role="alert">
                ❌ <?php echo htmlspecialchars($loginError); ?>
            </div>
        <?php endif; ?>

        <?php if (!empty($loginSuccess)): ?>
            <div class="alert alert-success" role="alert">
                ✅ <?php echo htmlspecialchars($loginSuccess); ?>
            </div>
        <?php endif; ?>

        <!-- Login Form -->
        <form method="POST" class="login-form" id="loginForm" autocomplete="on">
            <!-- CSRF Protection -->
            <?php if ($app->config('security.csrf_protection')): ?>
                <input type="hidden" name="csrf_token" value="<?php echo htmlspecialchars($auth->generateCSRFToken()); ?>">
            <?php endif; ?>
            
            <input type="hidden" name="action" value="login">

            <div class="form-group">
                <label for="password" class="form-label">Admin Password</label>
                <div class="password-input">
                    <input 
                        type="password" 
                        id="password" 
                        name="password" 
                        class="form-control" 
                        placeholder="Enter your admin password"
                        required
                        autocomplete="current-password"
                        autofocus
                        minlength="3"
                        maxlength="100"
                    >
                    <button type="button" class="password-toggle" onclick="togglePassword()" aria-label="Toggle password visibility">
                        👁️
                    </button>
                </div>
            </div>

            <div class="remember-me">
                <input type="checkbox" id="remember" name="remember" value="1">
                <label for="remember">Remember me for 30 days</label>
            </div>

            <button type="submit" class="login-btn" id="loginBtn">
                <span class="btn-text">Login to Dashboard</span>
            </button>

            <div class="loading" id="loading" aria-live="polite">
                <div class="spinner"></div>
                <span>Authenticating...</span>
            </div>
        </form>

        <!-- System Features -->
        <div class="features">
            <h3>📋 System Features</h3>
            <ul class="feature-list">
                <li>Multi-business review management</li>
                <li>Smart review routing (internal/external)</li>
                <li>QR code generation & tracking</li>
                <li>Real-time analytics dashboard</li>
                <li>Automated email notifications</li>
                <li>Data export & reporting</li>
            </ul>
        </div>

        <!-- Security Information -->
        <div class="security-info">
            <p>🔒 Your session is secured with industry-standard encryption</p>
            <p>🛡️ Login attempts are monitored and rate-limited</p>
            <?php if ($app->config('app.environment') === 'development'): ?>
                <p>⚠️ Development Mode - Enhanced logging enabled</p>
            <?php endif; ?>
        </div>

        <!-- Help Text -->
        <div class="help-text">
            <p>Need help accessing your account?</p>
            <p><a href="mailto:<?php echo htmlspecialchars($app->config('reviews.admin_email')); ?>">Contact Support</a></p>
        </div>

        <!-- Footer -->
        <div class="footer">
            <p>&copy; <?php echo date('Y'); ?> <?php echo htmlspecialchars($app->config('app.name')); ?>. All rights reserved.</p>
            <p>Powered by Elevadex v<?php echo htmlspecialchars($app->config('app.version')); ?></p>
        </div>
    </div>

    <script>
        // Enhanced login form functionality
        document.addEventListener('DOMContentLoaded', function() {
            const loginForm = document.getElementById('loginForm');
            const passwordField = document.getElementById('password');
            const loginBtn = document.getElementById('loginBtn');
            const loading = document.getElementById('loading');
            let isSubmitting = false;

            // Toggle password visibility
            window.togglePassword = function() {
                const toggleBtn = document.querySelector('.password-toggle');
                
                if (passwordField.type === 'password') {
                    passwordField.type = 'text';
                    toggleBtn.textContent = '🙈';
                    toggleBtn.setAttribute('aria-label', 'Hide password');
                } else {
                    passwordField.type = 'password';
                    toggleBtn.textContent = '👁️';
                    toggleBtn.setAttribute('aria-label', 'Show password');
                }
            };

            // Handle form submission
            loginForm.addEventListener('submit', function(e) {
                if (isSubmitting) {
                    e.preventDefault();
                    return false;
                }

                const password = passwordField.value.trim();
                
                if (password.length < 3) {
                    e.preventDefault();
                    alert('Password must be at least 3 characters long');
                    passwordField.focus();
                    return false;
                }

                // Show loading state
                isSubmitting = true;
                loginBtn.style.display = 'none';
                loading.style.display = 'flex';
                
                // Disable form elements
                const formElements = loginForm.querySelectorAll('input, button');
                formElements.forEach(element => element.disabled = true);

                // Set a timeout to re-enable form if something goes wrong
                setTimeout(function() {
                    if (isSubmitting) {
                        isSubmitting = false;
                        loginBtn.style.display = 'block';
                        loading.style.display = 'none';
                        formElements.forEach(element => element.disabled = false);
                    }
                }, 10000); // 10 second timeout
            });

            // Handle Enter key in password field
            passwordField.addEventListener('keypress', function(e) {
                if (e.key === 'Enter' && !isSubmitting) {
                    loginForm.dispatchEvent(new Event('submit', { cancelable: true }));
                }
            });

            // Clear any error messages on input
            passwordField.addEventListener('input', function() {
                const errorAlert = document.querySelector('.alert-error');
                if (errorAlert && this.value.trim()) {
                    errorAlert.style.opacity = '0.5';
                }
                
                // Basic password strength indication
                if (this.value.length >= 6) {
                    this.style.borderColor = '#28a745';
                } else if (this.value.length > 0) {
                    this.style.borderColor = '#ffc107';
                } else {
                    this.style.borderColor = '#e9ecef';
                }
            });

            // Auto-focus password field
            passwordField.focus();

            // Handle browser back/forward buttons
            window.addEventListener('pageshow', function(event) {
                if (event.persisted) {
                    // Page was loaded from cache, reset form state
                    isSubmitting = false;
                    loginBtn.style.display = 'block';
                    loading.style.display = 'none';
                    const formElements = loginForm.querySelectorAll('input, button');
                    formElements.forEach(element => element.disabled = false);
                }
            });

            // Security: Clear password on page unload
            window.addEventListener('beforeunload', function() {
                if (!isSubmitting) {
                    passwordField.value = '';
                }
            });

            <?php if ($app->isDebug()): ?>
            // Debug mode: Log form interactions
            console.log('Login form initialized - Debug mode active');
            loginForm.addEventListener('submit', function() {
                console.log('Login form submitted');
            });
            <?php endif; ?>
        });

        // Prevent multiple form submissions
        window.addEventListener('beforeunload', function() {
            const loginBtn = document.getElementById('loginBtn');
            if (loginBtn) {
                loginBtn.disabled = true;
            }
        });
    </script>
</body>
</html>