<?php
/**
 * Elevadex Review Management System
 * Main Application Configuration
 * 
 * @version 2.0
 * @author Elevadex Development Team
 */

// Prevent direct access
if (!defined('ELEVADEX_APP')) {
    die('Direct access not allowed');
}

return [
    // Application Settings
    'app' => [
        'name' => 'Elevadex Review Management System',
        'version' => '2.0.0',
        'environment' => 'production', // development, staging, production
        'debug' => false,
        'timezone' => 'Asia/Almaty',
        'locale' => 'en',
        'url' => 'https://elevadex.com',
        'admin_url' => 'https://elevadex.com/admin',
    ],

    // Security Settings
    'security' => [
        'admin_password' => 'admin123', // CHANGE IN PRODUCTION!
        'session_name' => 'elevadex_admin_session',
        'session_lifetime' => 7200, // 2 hours
        'csrf_protection' => true,
        'rate_limiting' => true,
        'max_login_attempts' => 5,
        'lockout_duration' => 900, // 15 minutes
        'secure_cookies' => true,
        'password_hash_algo' => PASSWORD_ARGON2ID,
    ],

    // File & Upload Settings
    'uploads' => [
        'max_file_size' => 5 * 1024 * 1024, // 5MB
        'allowed_types' => ['jpg', 'jpeg', 'png', 'gif', 'webp'],
        'logo_max_width' => 500,
        'logo_max_height' => 500,
        'temp_cleanup_hours' => 24,
    ],

    // Paths
    'paths' => [
        'root' => dirname(__DIR__),
        'storage' => dirname(__DIR__) . '/storage',
        'data' => dirname(__DIR__) . '/storage/data',
        'uploads' => dirname(__DIR__) . '/storage/uploads',
        'logs' => dirname(__DIR__) . '/storage/logs',
        'cache' => dirname(__DIR__) . '/storage/generated/cache',
        'qr_codes' => dirname(__DIR__) . '/storage/generated/qr-codes',
        'pages' => dirname(__DIR__) . '/storage/generated/pages',
        'public' => dirname(__DIR__) . '/public',
        'admin' => dirname(__DIR__) . '/admin',
        'core' => dirname(__DIR__) . '/core',
    ],

    // Business Settings
    'business' => [
        'subdomain_min_length' => 3,
        'subdomain_max_length' => 50,
        'subdomain_pattern' => '/^[a-z0-9-]+$/',
        'auto_generate_pages' => true,
        'auto_generate_qr' => true,
        'default_review_platforms' => ['2gis', 'google', 'yandex'],
    ],

    // Review System
    'reviews' => [
        'positive_threshold' => 4, // 4-5 stars = positive (external)
        'negative_threshold' => 3, // 1-3 stars = negative (internal)
        'auto_email_notifications' => true,
        'admin_email' => 'admin@elevadex.com',
        'review_retention_days' => 365,
    ],

    // Analytics
    'analytics' => [
        'cache_duration' => 3600, // 1 hour
        'data_retention_days' => 730, // 2 years
        'export_formats' => ['json', 'csv', 'excel'],
        'chart_colors' => [
            'primary' => '#667eea',
            'secondary' => '#764ba2',
            'success' => '#28a745',
            'warning' => '#ffc107',
            'danger' => '#dc3545',
            'info' => '#17a2b8',
        ],
    ],

    // QR Code Settings
    'qr_codes' => [
        'default_size' => 300,
        'error_correction' => 'M', // L, M, Q, H
        'margin' => 4,
        'format' => 'png',
        'logo_size_ratio' => 0.2, // 20% of QR code size
        'cache_duration' => 86400, // 24 hours
    ],

    // Email Settings
    'email' => [
        'from_name' => 'Elevadex System',
        'from_email' => 'noreply@elevadex.com',
        'smtp_enabled' => false,
        'smtp_host' => '',
        'smtp_port' => 587,
        'smtp_username' => '',
        'smtp_password' => '',
        'smtp_encryption' => 'tls',
    ],

    // Logging
    'logging' => [
        'enabled' => true,
        'level' => 'info', // debug, info, warning, error
        'max_file_size' => 10 * 1024 * 1024, // 10MB
        'rotation' => true,
        'retention_days' => 30,
        'channels' => [
            'app' => 'storage/logs/app.log',
            'error' => 'storage/logs/error.log',
            'security' => 'storage/logs/security.log',
            'analytics' => 'storage/logs/analytics.log',
        ],
    ],

    // Performance
    'performance' => [
        'cache_enabled' => true,
        'gzip_compression' => true,
        'image_optimization' => true,
        'css_minification' => false, // Enable in production
        'js_minification' => false,  // Enable in production
    ],

    // API Settings (for future)
    'api' => [
        'enabled' => false,
        'version' => 'v1',
        'rate_limit' => 1000, // requests per hour
        'authentication' => 'token',
    ],

    // Maintenance
    'maintenance' => [
        'mode' => false,
        'message' => 'System maintenance in progress. Please try again later.',
        'allowed_ips' => [], // IPs that can access during maintenance
    ],
];
?>