<?php
/**
 * Elevadex Review Management System
 * Authentication Class
 * 
 * @version 2.0
 * @author Elevadex Development Team
 */

// Prevent direct access
if (!defined('ELEVADEX_APP')) {
    die('Direct access not allowed');
}

class Auth
{
    private $app;
    private $sessionName;
    private $maxAttempts;
    private $lockoutDuration;
    
    public function __construct($app)
    {
        $this->app = $app;
        $this->sessionName = $app->config('security.session_name');
        $this->maxAttempts = $app->config('security.max_login_attempts');
        $this->lockoutDuration = $app->config('security.lockout_duration');
    }
    
    /**
     * Attempt to log in the user
     */
    public function login($password, $remember = false)
    {
        try {
            // Check if IP is locked out
            if ($this->isLockedOut()) {
                $this->logSecurityEvent('login_attempt_blocked', [
                    'ip' => $this->getClientIP(),
                    'reason' => 'IP locked out due to too many failed attempts'
                ]);
                
                return [
                    'success' => false,
                    'message' => 'Too many failed login attempts. Please try again later.',
                    'locked_until' => $this->getLockoutExpiry()
                ];
            }
            
            // Validate password
            $adminPassword = $this->app->config('security.admin_password');
            
            if ($this->verifyPassword($password, $adminPassword)) {
                // Successful login
                $this->createSession();
                $this->clearFailedAttempts();
                
                // Set remember me cookie if requested
                if ($remember) {
                    $this->setRemember